(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     56756,       1316]
NotebookOptionsPosition[     55867,       1292]
NotebookOutlinePosition[     56310,       1309]
CellTagsIndexPosition[     56267,       1306]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   StyleBox[
    RowBox[{
     RowBox[{
      FormBox[
       RowBox[{
        StyleBox[" ",
         FontFamily->"Times",
         FontWeight->"Bold",
         FontSlant->"Plain"], 
        RowBox[{
         SubscriptBox[
          StyleBox["\[ScriptCapitalS]",
           FontFamily->"Times",
           FontWeight->"Bold",
           FontSlant->"Plain"], 
          StyleBox["m",
           FontFamily->"Times",
           FontWeight->"Bold",
           FontSlant->"Italic"]], 
         SubscriptBox[
          StyleBox["\[ScriptCapitalB]",
           FontFamily->"Times",
           FontWeight->"Bold",
           FontSlant->"Plain"], 
          StyleBox["n",
           FontFamily->"Times",
           FontWeight->"Bold",
           FontSlant->"Italic"]]}]}],
       TraditionalForm], " ", "partitioned", " ", "Polytope", " ", 
      "Formalism"}], " ", "\[IndentingNewLine]", 
     RowBox[{
     "of", " ", "constitutional", " ", "isomerism", " ", "graphing"}]}],
    FontSize->24], 
   StyleBox[" ",
    FontSize->24], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "input", " ", "directory", " ", "location", " ", "of", " ", "the", " ", 
    "species", " ", 
    RowBox[{"file", ".", " ", "Outputs"}], " ", "will", " ", "be", " ", 
    "save", " ", "here"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "dir", "=", 
     "\"\<C:\\\\\!\(\*StyleBox[\"...\",FontColor->RGBColor[1, 0, \
0]]\)\\\\species\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{"(*", 
     RowBox[{"Enter", " ", "the", " ", 
      RowBox[{"species_SmBn", ".", "txt"}], " ", "file", " ", "name", " ", 
      "here"}], "*)"}],
    FontSize->18,
    FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"file", "=", "\"\<species_D3h_S3B2.txt\>\""}], ";"}], 
   RowBox[{"(*", "\"\<species_D3h_S3B3_max222.txt\>\"", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"locants", "=", 
     RowBox[{"{", 
      RowBox[{"\"\<16\>\"", ",", "\"\<17\>\"", ",", "\"\<18\>\""}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"after", " ", "setting", " ", "the", " ", "above"}], ",", " ", 
      RowBox[{"press", " ", "<", "SHIFT", ">", 
       RowBox[{"+", 
        RowBox[{"<", "ENTER", ">"}]}]}]}], " ", "*)"}],
    FontSize->18,
    FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
   StyleBox["\[IndentingNewLine]",
    FontSize->18,
    FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "rules", " ", "to", " ", "map", " ", "the", " ", "site", " ", "locants", 
     " ", "onto", " ", "the", " ", "site", " ", "indices"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lomap", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"i", "-", "1"}], "->", 
        RowBox[{"locants", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "locants", "]"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"set", " ", "directory"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "dir", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"open", " ", "the", " ", "specified", " ", "file"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"str", "=", 
     RowBox[{"OpenRead", "[", "file", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"read", " ", "the", " ", 
     SubscriptBox["S", "m"], 
     SubscriptBox["B", "n"], " ", "class", " ", "from", " ", "the", " ", 
     "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"class", "=", 
     RowBox[{"ReadLine", "[", "str", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "read", " ", "the", " ", "site", " ", "symmetry", " ", "point", " ", 
     "group", " ", "from", " ", "the", " ", "file"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pg", "=", 
     RowBox[{
      RowBox[{"StringSplit", "[", 
       RowBox[{"ReadLine", "[", "str", "]"}], "]"}], "\[LeftDoubleBracket]", 
      "1", "\[RightDoubleBracket]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"generate", " ", "the", " ", "site", " ", "indices", "  ", "0"}],
      ",", 
     RowBox[{"...", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fullset", "=", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", 
       RowBox[{
        RowBox[{"Length", "[", "locants", "]"}], "-", "1"}]}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"extract", " ", "number", " ", "of", " ", "bonders"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bonders", "=", 
     RowBox[{"ToExpression", "[", 
      RowBox[{"StringTake", "[", 
       RowBox[{"class", ",", 
        RowBox[{"-", 
         RowBox[{"ToExpression", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"StringLength", "[", "class", "]"}], "-", 
            RowBox[{"Flatten", "[", 
             RowBox[{"StringPosition", "[", 
              RowBox[{"class", ",", "\"\<B\>\""}], "]"}], "]"}]}], "//", 
           "Last"}], "]"}]}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "number", " ", "of", " ", "genera", " ", "in", " ", "each", " ", "family",
      " ", "read", " ", "out", " ", "from", " ", "the", " ", "file"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ngenera", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"ToExpression", "[", 
        RowBox[{"StringTake", "[", 
         RowBox[{"#", ",", 
          RowBox[{"-", "5"}]}], "]"}], "]"}], "&"}], "/@", 
      RowBox[{"FindList", "[", 
       RowBox[{"file", ",", "\"\<Nber of genera for this family\>\""}], 
       "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "for", " ", "structuring", " ", "the", " ", "genera", " ", "check", " ", 
     "boxes"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"w", "=", 
     RowBox[{"Ceiling", "[", 
      RowBox[{"Sqrt", "[", "range", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "count", " ", "out", " ", "the", " ", "number", " ", "of", " ", "species",
      " ", "from", " ", "the", " ", "file"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"Nspecies", "=", 
     RowBox[{
      RowBox[{"Differences", "[", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{
            RowBox[{"StringSplit", "[", 
             RowBox[{"FindList", "[", 
              RowBox[{"file", ",", 
               RowBox[{"{", 
                RowBox[{"\"\<:\>\"", ",", "\"\<#\>\""}], "}"}]}], "]"}], 
             "]"}], ",", "\"\<family=\>\""}], "]"}], "\[LeftDoubleBracket]", 
          RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"FindList", "[", 
             RowBox[{"file", ",", 
              RowBox[{"{", 
               RowBox[{"\"\<:\>\"", ",", "\"\<#\>\""}], "}"}]}], "]"}], "]"}],
            "+", "1"}], "}"}]}], "]"}], "]"}], "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "count", " ", "out", " ", "the", " ", "number", " ", "of", " ", "genera", 
     " ", "from", " ", "the", " ", "file"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"range", "=", 
     RowBox[{"ToExpression", "[", 
      RowBox[{
       RowBox[{"StringSplit", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"FindList", "[", 
           RowBox[{"file", ",", "\"\<Nber genera=\>\""}], "]"}], 
          "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
         "\"\<=\>\""}], "]"}], "\[LeftDoubleBracket]", 
       RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "read", " ", "in", " ", "from", " ", "the", " ", "file", " ", "each", " ",
      "species", " ", "index", " ", "designation", " ", "within", " ", "each",
      " ", "genus"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"GenSpecies", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"StringTrim", "[", 
        RowBox[{"StringDrop", "[", 
         RowBox[{"#", ",", "8"}], "]"}], "]"}], "&"}], "/@", 
      RowBox[{"FoldPairList", "[", 
       RowBox[{"TakeDrop", ",", 
        RowBox[{"FindList", "[", 
         RowBox[{"file", ",", "\"\<: \>\""}], "]"}], ",", "Nspecies"}], 
       "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"GenSpecies", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"StringSplit", "[", 
        RowBox[{"#", ",", "\"\<:\>\""}], "]"}], "&"}], "/@", "GenSpecies"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "convert", " ", "species", " ", "index", " ", "designations", " ", "into",
      " ", "individual", " ", "bonder", " ", "sets"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Species", "=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"interp", "[", 
         RowBox[{"#", ",", "fullset"}], "]"}], "&"}], ",", "GenSpecies", ",", 
       RowBox[{"{", "3", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"list", " ", "of", " ", "graph", " ", "embeddings"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"embed", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<SpringElectricalEmbedding\>\"", ",", "\"\<SpringEmbedding\>\"", 
       ",", "\"\<HighDimensionalEmbedding\>\"", ",", 
       "\"\<GravityEmbedding\>\"", ",", "\"\<SphericalEmbedding\>\"", ",", 
       "\"\<BipartiteEmbedding\>\"", ",", "\"\<CircularEmbedding\>\"", ",", 
       "\"\<GridEmbedding\>\"", ",", "\"\<CircularMultipartiteEmbedding\>\"", 
       ",", "\"\<MultipartiteEmbedding\>\"", ",", "\"\<StarEmbedding\>\"", 
       ",", "\"\<PlanarEmbedding\>\"", ",", "\"\<SpectralEmbedding\>\"", ",", 
       "\"\<TutteEmbedding\>\""}], "}"}]}], ";"}], "\n", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"w", "=", 
       RowBox[{"Ceiling", "[", 
        RowBox[{"Sqrt", "[", "range", "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"selected", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"Species", "[", 
          RowBox[{"[", "choices", "]"}], "]"}], ",", "1"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"edges1", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"format", "[", 
          RowBox[{"#", ",", "lomap"}], "]"}], "&"}], "/@", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{
          RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
           RowBox[{"Table", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Table", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"comp", "[", 
                 RowBox[{
                  RowBox[{"selected", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], ",", 
                  RowBox[{"selected", "[", 
                   RowBox[{"[", "j", "]"}], "]"}], ",", "1", ",", "bonders"}],
                  "]"}], "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{"j", ",", 
                 RowBox[{"i", "+", "1"}], ",", 
                 RowBox[{"Length", "[", "selected", "]"}]}], "}"}]}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{
                RowBox[{"Length", "[", "selected", "]"}], "-", "1"}]}], 
              "}"}]}], "]"}], "\[IndentingNewLine]", "]"}], ",", 
          "\[IndentingNewLine]", "False"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"edges2", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"format", "[", 
          RowBox[{"#", ",", "lomap"}], "]"}], "&"}], "/@", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{
          RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
           RowBox[{"Table", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Table", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"comp", "[", 
                 RowBox[{
                  RowBox[{"selected", "[", 
                   RowBox[{"[", "i", "]"}], "]"}], ",", 
                  RowBox[{"selected", "[", 
                   RowBox[{"[", "j", "]"}], "]"}], ",", "2", ",", "bonders"}],
                  "]"}], "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{"j", ",", 
                 RowBox[{"i", "+", "1"}], ",", 
                 RowBox[{"Length", "[", "selected", "]"}]}], "}"}]}], "]"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{
                RowBox[{"Length", "[", "selected", "]"}], "-", "1"}]}], 
              "}"}]}], "]"}], "\[IndentingNewLine]", "]"}], ",", 
          "\[IndentingNewLine]", "False"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"gr1", "=", 
       RowBox[{"Graph", "[", 
        RowBox[{"edges1", ",", 
         RowBox[{"VertexSize", "\[Rule]", "vs"}], ",", 
         RowBox[{"VertexStyle", "\[Rule]", "VertexColour"}], ",", 
         RowBox[{"VertexLabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", "vsize", ",", 
            RowBox[{"Background", "\[Rule]", 
             TemplateBox[<|"color" -> RGBColor[1, 1, 1, 0.5]|>,
              "RGBColorSwatchTemplate"]}]}], "]"}]}], ",", 
         RowBox[{"VertexLabels", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{"\"\<Name\>\"", ",", "Below"}], "]"}]}], ",", 
         RowBox[{"EdgeStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"EdgeColour", ",", 
            RowBox[{"Thickness", "[", "et", "]"}]}], "]"}]}], ",", 
         RowBox[{"GraphLayout", "\[Rule]", 
          RowBox[{"{", "em", "}"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "s"}], ",", 
         RowBox[{"ImagePadding", "\[Rule]", "30"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"gr2", "=", 
       RowBox[{"Graph", "[", 
        RowBox[{"edges2", ",", 
         RowBox[{"VertexSize", "\[Rule]", "vs"}], ",", 
         RowBox[{"VertexStyle", "\[Rule]", "VertexColour"}], ",", 
         RowBox[{"VertexLabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", "vsize", ",", 
            RowBox[{"Background", "\[Rule]", 
             TemplateBox[<|"color" -> RGBColor[1, 1, 1, 0.5]|>,
              "RGBColorSwatchTemplate"]}]}], "]"}]}], ",", 
         RowBox[{"VertexLabels", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{"\"\<Name\>\"", ",", "Below"}], "]"}]}], ",", 
         RowBox[{"EdgeStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"EdgeColour", ",", 
            RowBox[{"Thickness", "[", "et", "]"}]}], "]"}]}], ",", 
         RowBox[{"GraphLayout", "\[Rule]", 
          RowBox[{"{", "em", "}"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "s"}], ",", 
         RowBox[{"ImagePadding", "\[Rule]", "30"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"gr12", "=", 
       RowBox[{"Graph", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"edges1", ",", "edges2"}], "]"}], ",", 
         RowBox[{"VertexSize", "\[Rule]", "vs"}], ",", 
         RowBox[{"VertexStyle", "\[Rule]", "VertexColour"}], ",", 
         RowBox[{"VertexLabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", "vsize", ",", 
            RowBox[{"Background", "\[Rule]", 
             TemplateBox[<|"color" -> RGBColor[1, 1, 1, 0.5]|>,
              "RGBColorSwatchTemplate"]}]}], "]"}]}], ",", 
         RowBox[{"VertexLabels", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{"\"\<Name\>\"", ",", "Below"}], "]"}]}], ",", 
         RowBox[{"EdgeStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"EdgeColour", ",", 
            RowBox[{"Thickness", "[", "et", "]"}]}], "]"}]}], ",", 
         RowBox[{"GraphLayout", "\[Rule]", 
          RowBox[{"{", "em", "}"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "s"}], ",", 
         RowBox[{"ImagePadding", "\[Rule]", "30"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Column", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"Column", "[", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"output1", "=", 
              RowBox[{"Column", "[", 
               RowBox[{"outputs", "[", 
                RowBox[{
                "class", ",", "\"\<\!\(\*SuperscriptBox[\(1\), \(st\)]\)\>\"",
                  ",", "pg", ",", "choices", ",", "em", ",", "gr1"}], "]"}], 
               "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"output2", "=", 
              RowBox[{"Column", "[", 
               RowBox[{"outputs", "[", 
                RowBox[{
                "class", ",", "\"\<\!\(\*SuperscriptBox[\(2\), \(nd\)]\)\>\"",
                  ",", "pg", ",", "choices", ",", "em", ",", "gr2"}], "]"}], 
               "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{"output3", "=", 
              RowBox[{"Column", "[", 
               RowBox[{"outputs", "[", 
                RowBox[{
                "class", ",", 
                 "\"\<\!\(\*SuperscriptBox[\(1\), \(st\)]\) and \
\!\(\*SuperscriptBox[\(2\), \(nd\)]\)\>\"", ",", "pg", ",", "choices", ",", 
                 "em", ",", "gr12"}], "]"}], "]"}]}]}], "\[IndentingNewLine]",
             "}"}], ",", 
           RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "em", ",", "\"\<SpringElectricalEmbedding\>\"", ",", 
         "\"\<Graph vertex layout\>\""}], "}"}], ",", "embed", ",", 
       RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
       RowBox[{"SynchronousUpdating", "\[Rule]", "True"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"choices", ",", 
         RowBox[{"{", "}"}], ",", "\"\<Genera included\>\""}], "}"}], ",", 
       RowBox[{"Range", "[", "range", "]"}], ",", 
       RowBox[{"Appearance", " ", "\[Rule]", " ", 
        RowBox[{"\"\<Horizontal\>\"", " ", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{"w", ",", "Automatic"}], "}"}]}]}], ",", 
       RowBox[{"ControlType", "\[Rule]", "CheckboxBar"}], ",", 
       RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
       RowBox[{"SynchronousUpdating", "\[Rule]", "True"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"vsize", ",", "11", ",", "\"\<Label size\>\""}], "}"}], ",", 
       "2", ",", "20", ",", 
       RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}], ",", 
       RowBox[{"SynchronousUpdating", "\[Rule]", "True"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "Delimiter", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"EdgeColour", ",", 
       TemplateBox[<|"color" -> RGBColor[0., 0.29, 0.91]|>,
        "RGBColorSwatchTemplate"]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"et", ",", ".003", ",", "\"\<Edge Thickness\>\""}], "}"}], 
       ",", ".0005", ",", ".01", ",", 
       RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}], ",", 
       RowBox[{"SynchronousUpdating", "\[Rule]", "True"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"VertexColour", ",", 
       TemplateBox[<|"color" -> RGBColor[0, 0, 0]|>,
        "RGBColorSwatchTemplate"]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"vs", ",", ".2", ",", "\"\<Vertex Size\>\""}], "}"}], ",", 
       ".02", ",", "1", ",", 
       RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}], ",", 
       RowBox[{"SynchronousUpdating", "\[Rule]", "True"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "400", ",", "\"\<Image size\>\""}], "}"}], ",", 
       "100", ",", "10000", ",", 
       RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}], ",", 
       RowBox[{"SynchronousUpdating", "\[Rule]", "True"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "fname", ",", "\"\<xxx\>\"", ",", 
         "\"\<root file name for saving\>\""}], "}"}], ",", 
       RowBox[{"ControlType", "\[Rule]", "InputField"}], ",", 
       RowBox[{"ContinuousAction", "\[Rule]", "False"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "x1", ",", "0", ",", 
         "\"\<\!\(\*SuperscriptBox[\(1\), \(st\)]\) order motions\>\""}], 
        "}"}], ",", 
       RowBox[{
        RowBox[{"Button", "[", 
         RowBox[{"\"\<Save\>\"", ",", 
          RowBox[{"exports", "[", 
           RowBox[{
           "fname", ",", "class", ",", "choices", ",", "\"\<1\>\"", ",", 
            "gr1", ",", "output1"}], "]"}]}], "]"}], "&"}], ",", 
       RowBox[{"SynchronousUpdating", "\[Rule]", "True"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "x2", ",", "0", ",", 
         "\"\<\!\(\*SuperscriptBox[\(2\), \(nd\)]\) order motions\>\""}], 
        "}"}], ",", 
       RowBox[{
        RowBox[{"Button", "[", 
         RowBox[{"\"\<Save\>\"", ",", 
          RowBox[{"exports", "[", 
           RowBox[{
           "fname", ",", "class", ",", "choices", ",", "\"\<2\>\"", ",", 
            "gr2", ",", "output2"}], "]"}]}], "]"}], "&"}], ",", 
       RowBox[{"SynchronousUpdating", "\[Rule]", "True"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "x3", ",", "0", ",", 
         "\"\<\!\(\*SuperscriptBox[\(1\), \(st\)]\) & \
\!\(\*SuperscriptBox[\(2\), \(nd\)]\)order motions\>\""}], "}"}], ",", 
       RowBox[{
        RowBox[{"Button", "[", 
         RowBox[{"\"\<Save\>\"", ",", 
          RowBox[{"exports", "[", 
           RowBox[{
           "fname", ",", "class", ",", "choices", ",", "\"\<1_2\>\"", ",", 
            "gr12", ",", "output3"}], "]"}]}], "]"}], "&"}], ",", 
       RowBox[{"SynchronousUpdating", "\[Rule]", "True"}]}], "}"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"ControlPlacement", "\[Rule]", "Top"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.936384125901735*^9, 3.9363841876878657`*^9}, {
   3.936427923703169*^9, 3.9364279799783554`*^9}, {3.9364299861814547`*^9, 
   3.936430019961439*^9}, {3.9364300871513567`*^9, 3.9364302372565947`*^9}, {
   3.9364691268083053`*^9, 3.9364691588846226`*^9}, {3.936469200314104*^9, 
   3.936469318315792*^9}, {3.9364693835724144`*^9, 3.9364696025199504`*^9}, {
   3.9364696551869135`*^9, 3.9364696700834026`*^9}, {3.9364697609879684`*^9, 
   3.936469870426839*^9}, {3.9364699010563364`*^9, 3.9364699190263844`*^9}, {
   3.9364761728356857`*^9, 3.936476247660348*^9}, {3.9364768178511443`*^9, 
   3.936476875850492*^9}, {3.9364846349141355`*^9, 3.9364846942442017`*^9}, {
   3.936486950020135*^9, 3.9364869719742365`*^9}, 3.9364885498613925`*^9, {
   3.9364891798156195`*^9, 3.9364892230006013`*^9}, {3.9364893810020847`*^9, 
   3.9364894090978136`*^9}, {3.936489879575951*^9, 3.936489884598202*^9}, 
   3.936490502256263*^9, {3.9364905356399193`*^9, 3.9364905393463674`*^9}, {
   3.9365074582816772`*^9, 3.936507459912709*^9}, 3.936507499384755*^9, {
   3.936507953658841*^9, 3.936507962886874*^9}, {3.936507998510253*^9, 
   3.9365080739529305`*^9}, 3.9365569824420753`*^9, {3.9365570693466115`*^9, 
   3.9365570778169765`*^9}, 3.9365571395053654`*^9, {3.936557294984177*^9, 
   3.9365572961898975`*^9}, {3.9365575053472652`*^9, 
   3.9365575188447285`*^9}, {3.936557655922016*^9, 3.936557672526361*^9}, {
   3.9365581416066084`*^9, 3.9365581471213207`*^9}, {3.9365581806966248`*^9, 
   3.936558202183733*^9}, {3.936558232274494*^9, 3.936558232417591*^9}, {
   3.936558279157977*^9, 3.936558294088215*^9}, 3.93655864444063*^9, {
   3.936577783180676*^9, 3.936577783307121*^9}, {3.9365778724569283`*^9, 
   3.9365778747144938`*^9}, {3.936582415693826*^9, 3.9365824159196663`*^9}, 
   3.9365828991408424`*^9, {3.936583939401805*^9, 3.936583946203911*^9}, {
   3.9365841262560205`*^9, 3.936584126431405*^9}, {3.93658416647867*^9, 
   3.9365842009129715`*^9}, 3.936584235089922*^9, {3.9365843630440598`*^9, 
   3.936584369573578*^9}, {3.9433043503657246`*^9, 3.943304352925152*^9}, {
   3.943304425764042*^9, 3.943304477871311*^9}, {3.943304515754671*^9, 
   3.943304565741144*^9}, {3.943304603996378*^9, 
   3.9433046171167755`*^9}},ExpressionUUID->"7a8ed230-c5ec-4d0b-883a-\
25d3f2445d4d"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`choices$$ = {1, 2, 3, 
    4}, $CellContext`EdgeColour$$ = RGBColor[
    0., 0.29, 0.91], $CellContext`em$$ = 
    "SpringElectricalEmbedding", $CellContext`et$$ = 
    0.003, $CellContext`fname$$ = "xxx", $CellContext`s$$ = 
    400, $CellContext`VertexColour$$ = RGBColor[0, 0, 0], $CellContext`vs$$ = 
    0.2, $CellContext`vsize$$ = 11, $CellContext`x1$$ = 0, $CellContext`x2$$ =
     0, $CellContext`x3$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`em$$], "SpringElectricalEmbedding", 
       "Graph vertex layout"}, {
      "SpringElectricalEmbedding", "SpringEmbedding", 
       "HighDimensionalEmbedding", "GravityEmbedding", "SphericalEmbedding", 
       "BipartiteEmbedding", "CircularEmbedding", "GridEmbedding", 
       "CircularMultipartiteEmbedding", "MultipartiteEmbedding", 
       "StarEmbedding", "PlanarEmbedding", "SpectralEmbedding", 
       "TutteEmbedding"}, ControlType -> PopupMenu}, {{
       Hold[$CellContext`choices$$], {}, "Genera included"}, {1, 2, 3, 4, 5, 
      6, 7, 8, 9}, ControlType -> CheckboxBar}, {{
       Hold[$CellContext`vsize$$], 11, "Label size"}, 2, 20, ControlType -> 
      Manipulator}, {
      Hold[$CellContext`EdgeColour$$], 
      RGBColor[0., 0.29, 0.91], ControlType -> ColorSlider}, {{
       Hold[$CellContext`et$$], 0.003, "Edge Thickness"}, 0.0005, 0.01, 
      ControlType -> Manipulator}, {
      Hold[$CellContext`VertexColour$$], 
      RGBColor[0, 0, 0], ControlType -> ColorSlider}, {{
       Hold[$CellContext`vs$$], 0.2, "Vertex Size"}, 0.02, 1, ControlType -> 
      Manipulator}, {{
       Hold[$CellContext`s$$], 400, "Image size"}, 100, 10000, ControlType -> 
      Manipulator}, {{
       Hold[$CellContext`fname$$], "xxx", "root file name for saving"}, 
      ControlType -> InputField}, {{
       Hold[$CellContext`x1$$], 0, 
       "\!\(\*SuperscriptBox[\(1\), \(st\)]\) order motions"}, 
      Dynamic[Button["Save", 
        $CellContext`exports[$CellContext`fname$$, $CellContext`class, \
$CellContext`choices$$, "1", $CellContext`gr1, $CellContext`output1]]& ], 
      ControlType -> Automatic}, {{
       Hold[$CellContext`x2$$], 0, 
       "\!\(\*SuperscriptBox[\(2\), \(nd\)]\) order motions"}, 
      Dynamic[Button["Save", 
        $CellContext`exports[$CellContext`fname$$, $CellContext`class, \
$CellContext`choices$$, "2", $CellContext`gr2, $CellContext`output2]]& ], 
      ControlType -> Automatic}, {{
       Hold[$CellContext`x3$$], 0, 
       "\!\(\*SuperscriptBox[\(1\), \(st\)]\) & \!\(\*SuperscriptBox[\(2\), \
\(nd\)]\)order motions"}, 
      Dynamic[Button["Save", 
        $CellContext`exports[$CellContext`fname$$, $CellContext`class, \
$CellContext`choices$$, "1_2", $CellContext`gr12, $CellContext`output3]]& ], 
      ControlType -> Automatic}}, Typeset`size$$ = {
    414.4000000000001, {831.4837273355477, 837.2156611395437}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`choices$$ = {}, $CellContext`EdgeColour$$ = 
        RGBColor[0., 0.29, 0.91], $CellContext`em$$ = 
        "SpringElectricalEmbedding", $CellContext`et$$ = 
        0.003, $CellContext`fname$$ = "xxx", $CellContext`s$$ = 
        400, $CellContext`VertexColour$$ = 
        RGBColor[0, 0, 0], $CellContext`vs$$ = 0.2, $CellContext`vsize$$ = 
        11, $CellContext`x1$$ = 0, $CellContext`x2$$ = 0, $CellContext`x3$$ = 
        0}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, "Body" :> ($CellContext`w = Ceiling[
          Sqrt[$CellContext`range]]; $CellContext`selected = Flatten[
          Part[$CellContext`Species, $CellContext`choices$$], 
          1]; $CellContext`edges1 = 
        Map[$CellContext`format[#, $CellContext`lomap]& , 
          DeleteCases[
           Flatten[
            Table[
             Table[{
               $CellContext`comp[
                Part[$CellContext`selected, $CellContext`i], 
                Part[$CellContext`selected, $CellContext`j], 
                1, $CellContext`bonders]}, {$CellContext`j, $CellContext`i + 
               1, 
               Length[$CellContext`selected]}], {$CellContext`i, 
              Length[$CellContext`selected] - 1}]], 
           False]]; $CellContext`edges2 = 
        Map[$CellContext`format[#, $CellContext`lomap]& , 
          DeleteCases[
           Flatten[
            Table[
             Table[{
               $CellContext`comp[
                Part[$CellContext`selected, $CellContext`i], 
                Part[$CellContext`selected, $CellContext`j], 
                2, $CellContext`bonders]}, {$CellContext`j, $CellContext`i + 
               1, 
               Length[$CellContext`selected]}], {$CellContext`i, 
              Length[$CellContext`selected] - 1}]], False]]; $CellContext`gr1 = 
        Graph[$CellContext`edges1, VertexSize -> $CellContext`vs$$, 
          VertexStyle -> $CellContext`VertexColour$$, VertexLabelStyle -> 
          Directive[
           Black, $CellContext`vsize$$, Background -> RGBColor[1, 1, 1, 0.5]],
           VertexLabels -> Placed["Name", Below], EdgeStyle -> 
          Directive[$CellContext`EdgeColour$$, 
            Thickness[$CellContext`et$$]], GraphLayout -> {$CellContext`em$$},
           ImageSize -> $CellContext`s$$, ImagePadding -> 
          30]; $CellContext`gr2 = 
        Graph[$CellContext`edges2, VertexSize -> $CellContext`vs$$, 
          VertexStyle -> $CellContext`VertexColour$$, VertexLabelStyle -> 
          Directive[
           Black, $CellContext`vsize$$, Background -> RGBColor[1, 1, 1, 0.5]],
           VertexLabels -> Placed["Name", Below], EdgeStyle -> 
          Directive[$CellContext`EdgeColour$$, 
            Thickness[$CellContext`et$$]], GraphLayout -> {$CellContext`em$$},
           ImageSize -> $CellContext`s$$, ImagePadding -> 
          30]; $CellContext`gr12 = Graph[
          Join[$CellContext`edges1, $CellContext`edges2], 
          VertexSize -> $CellContext`vs$$, 
          VertexStyle -> $CellContext`VertexColour$$, VertexLabelStyle -> 
          Directive[
           Black, $CellContext`vsize$$, Background -> RGBColor[1, 1, 1, 0.5]],
           VertexLabels -> Placed["Name", Below], EdgeStyle -> 
          Directive[$CellContext`EdgeColour$$, 
            Thickness[$CellContext`et$$]], GraphLayout -> {$CellContext`em$$},
           ImageSize -> $CellContext`s$$, ImagePadding -> 30]; Column[{
          Column[{$CellContext`output1 = Column[
              $CellContext`outputs[$CellContext`class, 
               "\!\(\*SuperscriptBox[\(1\), \(st\)]\)", $CellContext`pg, \
$CellContext`choices$$, $CellContext`em$$, $CellContext`gr1]], \
$CellContext`output2 = Column[
              $CellContext`outputs[$CellContext`class, 
               "\!\(\*SuperscriptBox[\(2\), \(nd\)]\)", $CellContext`pg, \
$CellContext`choices$$, $CellContext`em$$, $CellContext`gr2]], \
$CellContext`output3 = Column[
              $CellContext`outputs[$CellContext`class, 
               "\!\(\*SuperscriptBox[\(1\), \(st\)]\) and \
\!\(\*SuperscriptBox[\(2\), \(nd\)]\)", $CellContext`pg, \
$CellContext`choices$$, $CellContext`em$$, $CellContext`gr12]]}, Frame -> 
           All]}, Frame -> All]), 
      "Specifications" :> {{{$CellContext`em$$, "SpringElectricalEmbedding", 
          "Graph vertex layout"}, {
         "SpringElectricalEmbedding", "SpringEmbedding", 
          "HighDimensionalEmbedding", "GravityEmbedding", 
          "SphericalEmbedding", "BipartiteEmbedding", "CircularEmbedding", 
          "GridEmbedding", "CircularMultipartiteEmbedding", 
          "MultipartiteEmbedding", "StarEmbedding", "PlanarEmbedding", 
          "SpectralEmbedding", "TutteEmbedding"}, ContinuousAction -> False, 
         SynchronousUpdating -> 
         True}, {{$CellContext`choices$$, {}, "Genera included"}, {1, 2, 3, 4,
          5, 6, 7, 8, 9}, Appearance -> ("Horizontal" -> {6, Automatic}), 
         ControlType -> CheckboxBar, ContinuousAction -> False, 
         SynchronousUpdating -> 
         True}, {{$CellContext`vsize$$, 11, "Label size"}, 2, 20, 
         ContinuousAction -> False, Appearance -> "Open", SynchronousUpdating -> 
         True}, Delimiter, {$CellContext`EdgeColour$$, 
         RGBColor[
         0., 0.29, 0.91]}, {{$CellContext`et$$, 0.003, "Edge Thickness"}, 
         0.0005, 0.01, ContinuousAction -> False, Appearance -> "Open", 
         SynchronousUpdating -> True}, {$CellContext`VertexColour$$, 
         RGBColor[0, 0, 0]}, {{$CellContext`vs$$, 0.2, "Vertex Size"}, 0.02, 
         1, ContinuousAction -> False, Appearance -> "Open", 
         SynchronousUpdating -> True}, {{$CellContext`s$$, 400, "Image size"},
          100, 10000, ContinuousAction -> False, Appearance -> "Open", 
         SynchronousUpdating -> True}, 
        Delimiter, {{$CellContext`fname$$, "xxx", 
          "root file name for saving"}, ControlType -> InputField, 
         ContinuousAction -> 
         False}, {{$CellContext`x1$$, 0, 
          "\!\(\*SuperscriptBox[\(1\), \(st\)]\) order motions"}, 
         Dynamic[Button["Save", 
           $CellContext`exports[$CellContext`fname$$, $CellContext`class, \
$CellContext`choices$$, "1", $CellContext`gr1, $CellContext`output1]]& ], 
         SynchronousUpdating -> 
         True}, {{$CellContext`x2$$, 0, 
          "\!\(\*SuperscriptBox[\(2\), \(nd\)]\) order motions"}, 
         Dynamic[Button["Save", 
           $CellContext`exports[$CellContext`fname$$, $CellContext`class, \
$CellContext`choices$$, "2", $CellContext`gr2, $CellContext`output2]]& ], 
         SynchronousUpdating -> 
         True}, {{$CellContext`x3$$, 0, 
          "\!\(\*SuperscriptBox[\(1\), \(st\)]\) & \
\!\(\*SuperscriptBox[\(2\), \(nd\)]\)order motions"}, 
         Dynamic[Button["Save", 
           $CellContext`exports[$CellContext`fname$$, $CellContext`class, \
$CellContext`choices$$, "1_2", $CellContext`gr12, $CellContext`output3]]& ], 
         SynchronousUpdating -> True}}, 
      "Options" :> {ControlPlacement -> Top}, "DefaultOptions" :> {}],
     ImageSizeCache->{
      458.5000000000001, {1081.415749076502, 1087.147682880498}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.9365835038851423`*^9, 3.936583557287531*^9}, {
   3.936583948003793*^9, 3.93658401168824*^9}, {3.936584126982134*^9, 
   3.936584134062011*^9}, 3.9365841674729786`*^9, 3.936584201784383*^9, {
   3.936584236171527*^9, 3.9365842588946953`*^9}, {3.936584370135711*^9, 
   3.9365843731651006`*^9}, {3.936584437842387*^9, 3.9365844449831824`*^9}, {
   3.936584490347717*^9, 3.9365844932394648`*^9}, {3.9365845261880713`*^9, 
   3.9365845493940763`*^9}, {3.943304332278858*^9, 3.9433043705501423`*^9}},
 CellLabel->
  "Out[265]=",ExpressionUUID->"a3a9af45-6cac-ed4c-ba2b-5152af7df28b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "converts", " ", "a", " ", "single", " ", "bonder", " ", "configuration", 
    " ", "string", " ", "into", " ", "a", " ", "numerical", " ", 
    RowBox[{"set", ".", " ", "Handles"}], " ", "set", " ", "complement", " ", 
    "notation"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"interp", "[", "a_", "]"}], ":=", 
    RowBox[{"ToExpression", "[", 
     RowBox[{"\"\<{\>\"", "<>", "a", "<>", "\"\<}\>\""}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"interp", "[", 
     RowBox[{"a_", ",", "set_"}], "]"}], ":=", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"StringTake", "[", 
        RowBox[{"a", ",", "1"}], "]"}], "==", "\"\<\\\\\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Complement", "[", 
       RowBox[{"set", ",", 
        RowBox[{"interp", "[", 
         RowBox[{"StringDrop", "[", 
          RowBox[{"a", ",", "1"}], "]"}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"interp", "[", "a", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "formats", " ", "an", " ", "index", " ", "configuration", " ", "into", 
      " ", "colon"}], "-", 
     RowBox[{
     "separated", " ", "sites", " ", "locants", " ", "and", " ", "handles", 
      " ", "graph", " ", "edge", " ", "pairs"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"format", "[", 
     RowBox[{"sp_", ",", "locantmap_"}], "]"}], ":=", 
    RowBox[{"StringTrim", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"StringJoin", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"StringReplace", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"#", "/.", "locantmap"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\"\< \>\"", "->", "\"\<\>\""}], ",", 
              RowBox[{"\"\<{\>\"", "->", "\"\<\>\""}], ",", 
              RowBox[{"\"\<}\>\"", "->", "\"\<\>\""}]}], "}"}]}], "]"}], 
          "<>", "\"\<:\>\""}], "&"}], "/@", "sp"}], "]"}], ",", "\"\<:\>\""}],
      "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"format", "[", 
     RowBox[{
      RowBox[{"sp1_", "\[UndirectedEdge]", "sp2_"}], ",", "locantmap_"}], 
     "]"}], ":=", 
    RowBox[{
     RowBox[{"format", "[", 
      RowBox[{"sp1", ",", "locantmap"}], "]"}], "\[UndirectedEdge]", 
     RowBox[{"format", "[", 
      RowBox[{"sp2", ",", "locantmap"}], "]"}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "test", " ", "to", " ", "see", " ", "if", " ", "all", " ", "pairwise", 
     " ", "bonder", " ", "configurations", " ", "have", " ", "subset", " ", 
     "relationships"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OnlySubsetPairsQ", "[", 
     RowBox[{"s1_", ",", "s2_", ",", "1"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"SubsetQ", "[", 
      RowBox[{
       RowBox[{"s1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"s2", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "\[Or]", 
     RowBox[{"SubsetQ", "[", 
      RowBox[{
       RowBox[{"s2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"s1", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OnlySubsetPairsQ", "[", 
     RowBox[{"s1_", ",", "s2_", ",", "b_"}], "]"}], ":=", 
    RowBox[{"And", "[", 
     RowBox[{
      RowBox[{"OnlySubsetPairsQ", "[", 
       RowBox[{
        RowBox[{"Rest", "[", "s1", "]"}], ",", 
        RowBox[{"Rest", "[", "s2", "]"}], ",", 
        RowBox[{"b", "-", "1"}]}], "]"}], ",", 
      RowBox[{"OnlySubsetPairsQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"s1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"s2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", "1"}], "]"}]}], "]"}]}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "compares", " ", "two", " ", "configurations", " ", "to", " ", 
     "determine", " ", "the", " ", "\"\<motions order\>\""}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"comp", "[", 
     RowBox[{"s1_", ",", "s2_", ",", "order_", ",", "b_"}], "]"}], ":=", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"OnlySubsetPairsQ", "[", 
       RowBox[{"s1", ",", "s2", ",", "b"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "\[IndentingNewLine]", 
          RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
           RowBox[{"Table", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"If", "[", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"SubsetQ", "[", 
                RowBox[{
                 RowBox[{"s1", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], ",", 
                 RowBox[{"s2", "[", 
                  RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"Complement", "[", 
                RowBox[{
                 RowBox[{"s1", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], ",", 
                 RowBox[{"s2", "[", 
                  RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"SubsetQ", "[", 
                  RowBox[{
                   RowBox[{"s2", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", 
                   RowBox[{"s1", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
                 RowBox[{"Complement", "[", 
                  RowBox[{
                   RowBox[{"s2", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", 
                   RowBox[{"s1", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
               RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "bonders"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}], "==", 
         "order"}], ",", 
        RowBox[{"s1", "\[UndirectedEdge]", "s2"}], ",", "False"}], "]"}], ",",
       "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"format", " ", "the", " ", "graph", " ", "outputs"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"outputs", "[", 
     RowBox[{
     "class_", ",", "motions_", ",", "pg_", ",", "choices_", ",", "em_", ",", 
      "gr_"}], "]"}], ":=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
      "\"\<Class: \>\"", "<>", "class", "<>", 
       "\"\< with site symmetry point group \>\"", "<>", "pg"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<Genera included = \>\"", "<>", " ", 
       RowBox[{"ToString", "[", 
        RowBox[{"Sort", "[", "choices", "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"motions", "<>", "\"\< order motions graph:\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<Graph vertex layout: \>\"", "<>", "em"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<Hamiltonian graph? \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"HamiltonianGraphQ", "[", "gr", "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<Eulerian graph? \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"EulerianGraphQ", "[", "gr", "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<Planar graph? \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"PlanarGraphQ", "[", "gr", "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<Graph radius = \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"GraphRadius", "[", "gr", "]"}], "//", "N"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<Graph diameter = \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"GraphDiameter", "[", "gr", "]"}], "//", "N"}], "]"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"\"\<Graph density = \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"GraphDensity", "[", "gr", "]"}], "//", "N"}], "]"}]}], ",", 
      "\[IndentingNewLine]", "gr"}], "}"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "function", " ", "to", " ", "export", " ", "graph", " ", "and", " ", 
     "properties"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exports", "[", 
     RowBox[{
     "fname_", ",", "class_", ",", "choices_", ",", "tag_", ",", "gr_", ",", 
      "content_"}], "]"}], ":=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"export", " ", "the", " ", "edge", " ", "list"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ToString", "[", "fname", "]"}], "<>", "\"\<_\>\"", "<>", 
         "class", "<>", "\"\<_genera\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"Sort", "[", "choices", "]"}], "]"}], "<>", 
         "\"\<_edges_\>\"", "<>", "tag", "<>", "\"\<.txt\>\""}], ",", 
        RowBox[{"EdgeList", "[", "gr", "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "export", " ", "graph", " ", "as", " ", "a", " ", "pdf", " ", "file"}],
        "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ToString", "[", "fname", "]"}], "<>", "\"\<_\>\"", "<>", 
         "class", "<>", "\"\<_genera\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"Sort", "[", "choices", "]"}], "]"}], "<>", "\"\<_\>\"", "<>",
          "tag", "<>", "\"\<.pdf\>\""}], ",", "content"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "export", " ", "graph", " ", "as", " ", "a", " ", "gxl", " ", "file"}],
        "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ToString", "[", "fname", "]"}], "<>", "\"\<_\>\"", "<>", 
         "class", "<>", "\"\<_genera\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"Sort", "[", "choices", "]"}], "]"}], "<>", "\"\<_\>\"", "<>",
          "tag", "<>", "\"\<.gxl\>\""}], ",", "gr"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "export", " ", "the", " ", "vertex", " ", "list", " ", "as", " ", "a", 
        " ", "text", " ", "file"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ToString", "[", "fname", "]"}], "<>", "\"\<_\>\"", "<>", 
         "class", "<>", "\"\<_genera\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"Sort", "[", "choices", "]"}], "]"}], "<>", 
         "\"\<_Vertex_List_\>\"", "<>", "tag", "<>", "\"\<.txt\>\""}], ",", 
        RowBox[{"VertexList", "[", "gr", "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "export", " ", "the", " ", "distance", " ", "table", " ", "as", " ", 
        "a", " ", "data", " ", "file"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ToString", "[", "fname", "]"}], "<>", "\"\<_\>\"", "<>", 
         "class", "<>", "\"\<_genera\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"Sort", "[", "choices", "]"}], "]"}], "<>", 
         "\"\<_Distance_Matrix_\>\"", "<>", "tag", "<>", "\"\<.dat\>\""}], 
        ",", 
        RowBox[{"GraphDistanceMatrix", "[", "gr", "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "export", " ", "the", " ", "adjacency", " ", "matrix", " ", "as", " ", 
        "a", " ", "data", " ", "file"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ToString", "[", "fname", "]"}], "<>", "\"\<_\>\"", "<>", 
         "class", "<>", "\"\<_genera\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"Sort", "[", "choices", "]"}], "]"}], "<>", 
         "\"\<_Adjacency_Matrix_\>\"", "<>", "tag", "<>", "\"\<.dat\>\""}], 
        ",", 
        RowBox[{"AdjacencyMatrix", "[", "gr", "]"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.93647613040064*^9, {3.936476264649975*^9, 3.936476291829475*^9}, {
   3.9364763223353167`*^9, 3.9364763500905848`*^9}, {3.9364763884657955`*^9, 
   3.9364764555279675`*^9}, {3.9364765033992043`*^9, 3.936476536336182*^9}, {
   3.9364765924245987`*^9, 3.9364766723767796`*^9}, {3.9364767039449806`*^9, 
   3.9364767690995855`*^9}, {3.936483072864133*^9, 3.9364831113358793`*^9}, {
   3.9364845549141674`*^9, 3.936484588797316*^9}, {3.9365572258296137`*^9, 
   3.936557238569685*^9}, {3.936557610018258*^9, 3.936557616556861*^9}, {
   3.936561552290165*^9, 3.9365615909661674`*^9}, {3.9365758422390904`*^9, 
   3.9365758735847397`*^9}, {3.9365762021687565`*^9, 
   3.9365762091524935`*^9}, {3.9365763250301094`*^9, 3.9365763729617224`*^9}, 
   3.936577410730934*^9, {3.9365774872638535`*^9, 3.9365774899922576`*^9}, 
   3.9365777034922543`*^9, {3.9365805239831696`*^9, 3.9365805909013233`*^9}, {
   3.936580797093871*^9, 3.936580828803585*^9}, {3.9365808653633356`*^9, 
   3.936580885247892*^9}, {3.93658092384789*^9, 3.9365809657190065`*^9}, {
   3.9365822910643435`*^9, 3.936582373046839*^9}},
 CellLabel->
  "In[219]:=",ExpressionUUID->"a28719d6-e49e-4b95-9591-71ee7a0c1df6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"VertexList", "[", "gr1", "]"}], ",", 
     RowBox[{"VertexDegree", "[", "gr1", "]"}]}], "}"}], "//", "Transpose"}], 
  "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.9365835837069454`*^9, 3.9365835847155485`*^9}, {
  3.936583817852598*^9, 3.9365838359493065`*^9}, {3.936584088393696*^9, 
  3.936584111090996*^9}},
 CellLabel->
  "In[727]:=",ExpressionUUID->"82b9af13-247e-4016-9339-35828736e736"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"16:16\"\>", "4"},
    {"\<\"16:16,17\"\>", "4"},
    {"\<\"16,17:16\"\>", "4"},
    {"\<\"16:16,3\"\>", "4"},
    {"\<\"16,3:16\"\>", "4"},
    {"\<\"17:17\"\>", "4"},
    {"\<\"17:17,18\"\>", "4"},
    {"\<\"17,18:17\"\>", "4"},
    {"\<\"17:16,17\"\>", "4"},
    {"\<\"16,17:17\"\>", "4"},
    {"\<\"18:18\"\>", "4"},
    {"\<\"18:18,3\"\>", "4"},
    {"\<\"18,3:18\"\>", "4"},
    {"\<\"18:17,18\"\>", "4"},
    {"\<\"17,18:18\"\>", "4"},
    {"\<\"3:3\"\>", "4"},
    {"\<\"3:16,3\"\>", "4"},
    {"\<\"16,3:3\"\>", "4"},
    {"\<\"3:18,3\"\>", "4"},
    {"\<\"18,3:3\"\>", "4"},
    {"\<\"16,17:16,17\"\>", "4"},
    {"\<\"17,18:17,18\"\>", "4"},
    {"\<\"18,3:18,3\"\>", "4"},
    {"\<\"16,3:16,3\"\>", "4"},
    {"\<\"16:17,18\"\>", "4"},
    {"\<\"16,17:17,18\"\>", "4"},
    {"\<\"16,3:17,18\"\>", "4"},
    {"\<\"16:17\"\>", "4"},
    {"\<\"16:18\"\>", "4"},
    {"\<\"17,18:16\"\>", "4"},
    {"\<\"17,18:16,17\"\>", "4"},
    {"\<\"17,18:16,3\"\>", "4"},
    {"\<\"17:16\"\>", "4"},
    {"\<\"18:16\"\>", "4"},
    {"\<\"17:18,3\"\>", "4"},
    {"\<\"17,18:18,3\"\>", "4"},
    {"\<\"16,17:18,3\"\>", "4"},
    {"\<\"17:18\"\>", "4"},
    {"\<\"17:3\"\>", "4"},
    {"\<\"18,3:17\"\>", "4"},
    {"\<\"18,3:17,18\"\>", "4"},
    {"\<\"18,3:16,17\"\>", "4"},
    {"\<\"18:17\"\>", "4"},
    {"\<\"3:17\"\>", "4"},
    {"\<\"18:16,3\"\>", "4"},
    {"\<\"18,3:16,3\"\>", "4"},
    {"\<\"18:3\"\>", "4"},
    {"\<\"16,3:18\"\>", "4"},
    {"\<\"16,3:18,3\"\>", "4"},
    {"\<\"3:18\"\>", "4"},
    {"\<\"3:16,17\"\>", "4"},
    {"\<\"16,3:16,17\"\>", "4"},
    {"\<\"3:16\"\>", "4"},
    {"\<\"16,17:3\"\>", "4"},
    {"\<\"16,17:16,3\"\>", "4"},
    {"\<\"16:3\"\>", "4"},
    {"\<\"16:18,3\"\>", "4"},
    {"\<\"18,3:16\"\>", "4"},
    {"\<\"17:16,3\"\>", "4"},
    {"\<\"16,3:17\"\>", "4"},
    {"\<\"18:16,17\"\>", "4"},
    {"\<\"16,17:18\"\>", "4"},
    {"\<\"3:17,18\"\>", "4"},
    {"\<\"17,18:3\"\>", "4"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.936583828433693*^9, 3.93658383697266*^9}, 
   3.9365840399823413`*^9, {3.9365840937322454`*^9, 3.9365841393632345`*^9}, 
   3.9365848862105384`*^9},
 CellLabel->
  "Out[727]//TableForm=",ExpressionUUID->"7b95d387-0197-4787-a9fe-\
e629bd7884e8"]
}, Open  ]]
},
WindowSize->{725.625, 598.875},
WindowMargins->{{154.875, Automatic}, {9.375, Automatic}},
Magnification:>1. Inherited,
FrontEndVersion->"14.1 for Microsoft Windows (64-bit) (July 16, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"aa37457e-8889-409a-bced-7c39ed873d8a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 26221, 618, 2617, "Input",ExpressionUUID->"7a8ed230-c5ec-4d0b-883a-25d3f2445d4d"],
Cell[26804, 642, 11743, 213, 2185, "Output",ExpressionUUID->"a3a9af45-6cac-ed4c-ba2b-5152af7df28b"]
}, Open  ]],
Cell[38562, 858, 14176, 331, 1433, "Input",ExpressionUUID->"a28719d6-e49e-4b95-9591-71ee7a0c1df6",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[52763, 1193, 481, 12, 28, "Input",ExpressionUUID->"82b9af13-247e-4016-9339-35828736e736"],
Cell[53247, 1207, 2604, 82, 1101, "Output",ExpressionUUID->"7b95d387-0197-4787-a9fe-e629bd7884e8"]
}, Open  ]]
}
]
*)

